<?php if (!defined('__TYPECHO_ROOT_DIR__')) exit; ?>

<!-- Sidebar -->
<div id="sidebar">
	<!-- Logo -->
	<div id="logo">
		<h1><a href="<?php $this->options->siteUrl(); ?>"><?php $this->options->title(); ?></a></h1>
		<p><?php $this->options->description() ?></p>
	</div>

	<!-- Search -->
	<section class="box search">
		<form method="post" action="<?php $this->options->siteUrl(); ?>">
			<input type="text" class="text" name="s" placeholder="<?php _e('输入关键字搜索'); ?>" />
		</form>
	</section>

	<!-- Nav -->
	<nav id="nav">
		<ul>
			<li class="<?php echo $this->is('index')?'current':'' ?>">
				<!-- 首页 -->
				<a href="<?php $this->options->siteUrl(); ?>">
					<span class="icon fa-home"> <?php _e('首页'); ?></span>
				</a>
			</li>
			<li class="list">
				<!-- 分类 -->
				<?php if (!empty($this->options->sidebarBlock) && in_array('ShowCategory', $this->options->sidebarBlock)): ?>
					<a><span class="icon fa-th"> <?php _e('分类'); ?></span></a>
					<ul <?php echo $this->is('category')?'style="display: block;"':'' ?>>
					<?php $this->widget('Widget_Metas_Category_List')->to($pages); ?>
					<?php while($pages->next()): ?>
						<li class="<?php echo $this->is('category', $pages->slug)?'current':'' ?> <?php echo ($pages->parent != '0')?'list-sub':'' ?>">
							<a href="<?php $pages->permalink(); ?>" title="<?php $pages->name(); ?>">
								<span><?php $pages->name(); ?></span>
							</a>
						</li>
					<?php endwhile; ?>
					</ul>
				<?php endif; ?>
			</li>
				<!-- 独立页 -->
				<?php if (!empty($this->options->sidebarBlock) && in_array('ShowPages', $this->options->sidebarBlock)): ?>
					<?php $this->widget('Widget_Contents_Page_List')->to($pages); ?>
					<?php while($pages->next()): ?>
						<li class="<?php echo $this->_archiveSlug == $pages->slug?'current':'' ?>">
							<a href="<?php $pages->permalink(); ?>" title="<?php $pages->title(); ?>">
								<span class="icon fa-user"> <?php $pages->title(); ?></span>
							</a>
						</li>
					<?php endwhile; ?>
				<?php endif; ?>
			</li>
			<li class="list">
				<!-- 其它 -->
				<?php if (!empty($this->options->sidebarBlock) && in_array('ShowOther', $this->options->sidebarBlock)): ?>
					<a><span class="icon fa-th"> <?php _e('其它'); ?></span></a>
					<ul <?php echo 'other' == $this->_archiveType?'style="display: block;"':'' ?>>
						<li>
						<?php if($this->user->hasLogin()): ?>
							<a href="<?php $this->options->adminUrl(); ?>"><?php _e('进入后台'); ?> (<?php $this->user->screenName(); ?>)</a>
							</li><li>
							<a href="<?php $this->options->logoutUrl(); ?>"><?php _e('退出'); ?></a>
						<?php else: ?>
						   <a href="<?php $this->options->adminUrl('login.php'); ?>"><?php _e('登录'); ?></a>
						<?php endif; ?>
						</li>
						<li><a href="<?php $this->options->feedUrl(); ?>"><?php _e('文章 RSS'); ?></a></li>
						<li class="last"><a href="<?php $this->options->commentsFeedUrl(); ?>"><?php _e('评论 RSS'); ?></a></li>
					</ul>
				<?php endif; ?>
			</li>
		</ul>
	</nav>

	<!-- Recent Posts -->
	<?php if (!empty($this->options->sidebarBlock) && in_array('ShowRecentPosts', $this->options->sidebarBlock)): ?>
	<section class="recent-posts">
		<header>
			<h2><?php _e('最新文章'); ?></h2>
		</header>
		<ul>
			<?php $this->widget('Widget_Contents_Post_Recent')->parse('<li><a href="{permalink}">{title}</a></li>'); ?>
		</ul>
	</section>
	<?php endif; ?>

	<!-- Recent Comments -->
	<?php if (!empty($this->options->sidebarBlock) && in_array('ShowRecentComments', $this->options->sidebarBlock)): ?>
	<section class="recent-comments">
		<header>
			<h2><?php _e('最近回复'); ?></h2>
		</header>
		<ul>
			<?php $this->widget('Widget_Comments_Recent')->to($comments); ?>
			<?php while($comments->next()): ?>
				<li>
					<a href="<?php $comments->permalink(); ?>">
					<?php $comments->author(false); ?></a>: <?php $comments->excerpt(30, '...'); ?>
				</li>
			<?php endwhile; ?>
		</ul>
	</section>
	<?php endif; ?>

	<!-- Archive Posts -->
	<?php if (!empty($this->options->sidebarBlock) && in_array('ShowRecentComments', $this->options->sidebarBlock)): ?>
	<section class="recent-comments">
		<header>
			<h2><?php _e('归档'); ?></h2>
		</header>
		<ul>
			<?php $this->widget('Widget_Contents_Post_Date', 'type=month&format=F Y')->to($posts); ?>
			<?php while($posts->next()): ?>
				<li>
					<a href="<?php $posts->permalink(); ?>"><?php $posts->date(); ?></a>
				</li>
			<?php endwhile; ?>
		</ul>
	</section>
	<?php endif; ?>

</div><!-- end #sidebar -->
