<?php if (!defined('__TYPECHO_ROOT_DIR__')) exit; ?>
<?php $this->need('header.php'); ?>
<?php $this->need('sidebar.php'); ?>

<!-- Content -->
<div id="content">
	<div class="inner">
		<!-- Post -->
		<article class="post">
			<?php include 'post-header.php'; ?>
			<hr>
			<div class="post-content">
				<?php $this->content(); ?>
			</div>
		</article>

		<ul>
			<li>上一篇: <?php $this->thePrev('%s','没有了'); ?></li>
			<li>下一篇: <?php $this->theNext('%s','没有了'); ?></li>
		</ul>

		<?php $this->need('comments.php'); ?>
	</div>
</div>

<?php if (!empty($this->options->article) && $this->options->article != ''): ?>
	<div id="catalog"><span class="icon fa-list"></span></div>

	<link rel="stylesheet" href="<?php $this->options->themeUrl(); ?>css/autoc.min.css?v1.3.0" />
	<script src="<?php $this->options->themeUrl(); ?>js/autoc.min.js?v1.3.0"></script>
	<script>
	// 展开侧边栏菜单
	AutocJS.prototype.show = function () {
		$('.autocjs-overlay').removeClass('autocjs-hide');
		$('.autocjs').css('transform', 'translateX(-300px)');

		return this;
	};

	// 收起侧边栏菜单
	AutocJS.prototype.hide = function () {
		$('.autocjs').css('transform', 'translateX(0)');
		$('.autocjs-overlay').addClass('autocjs-hide');
		$('.autocjs').removeClass('autocjs-show');

		return this;
	};

	var aj = new AutocJS({
		article: "<?php _e($this->options->article); ?>",
		title: "<?php $this->title(); ?>",
		hasChapterCodeInDirectory: false
	});

	$('#catalog').on('click', function (evt) {
		aj.toggle();

		evt.stopPropagation();
		evt.preventDefault();

		return evt;
	});
	</script>
	<style>
	.autocjs {
		transform: translateX(0);
		transition: all .35s linear;
		left: auto;
		right: -300px;
	}

	.autocjs-ft {
		display: none;
	}

	#catalog {
		background: #fff;
		border-radius: 3px;
		box-shadow: 0 0 20px #ccc;
		padding: 10px;
		width: 45px;
		height: 45px;
		position: fixed;
		top: 30px;
		right: 30px;
		opacity: 80;
		font-size: 1.5em;
		text-align: center;
		transition: all .35s linear;
	}

	/* Mobile */
	@media screen and (max-width: 736px) {
		.autocjs {
			width: 240px;
		}

		#catalog {
			background-color: #c94663;
			background-image: url(<?php $this->options->themeUrl(); ?>img/bg01.png);
			box-shadow: none;
			color: #fff;
			font-size: 1em;
			width: 50px;
			height: 30px;
			top: 7px;
			right: 7px;
			line-height: 12px;
			z-index: 105;
		}
		
		.sidebar-visible #catalog {
			transform: translateX(16em);
		}
	}
	</style>
<?php endif; ?>

<?php $this->need('footer.php'); ?>
