<?php
if (!defined('__TYPECHO_ROOT_DIR__')) exit;

function themeConfig($form) {
    $logoUrl = new Typecho_Widget_Helper_Form_Element_Text('logoUrl', NULL, NULL, _t('站点 LOGO 地址'), _t('在这里填入一个图片 URL 地址, 以在网站标题前加上一个 LOGO'));
    $form->addInput($logoUrl);
    
    $sidebarBlock = new Typecho_Widget_Helper_Form_Element_Checkbox('sidebarBlock', 
    array('ShowRecentPosts' => _t('显示最新文章'),
    'ShowRecentComments' => _t('显示最近回复'),
    'ShowCategory' => _t('显示分类'),
    'ShowArchive' => _t('显示归档'),
    'ShowPages' => _t('显示独立页'),
    'ShowOther' => _t('显示其它杂项')),
    array('ShowRecentPosts', 'ShowRecentComments', 'ShowCategory', 'ShowArchive', 'ShowPages', 'ShowOther'), _t('侧边栏显示'));
    
    $form->addInput($sidebarBlock->multiMode());
    
    $article = new Typecho_Widget_Helper_Form_Element_Text(
        'article',
        NULL,
        '.post-content',
        _t('文章目录'),
        _t('用来指定页面中显示文章正文的 DOM 节点或者 ID 选择器。如果没有指定它，则程序将不会执行')
    );
    $form->addInput($article);
}


/*
function themeFields($layout) {
    $logoUrl = new Typecho_Widget_Helper_Form_Element_Text('logoUrl', NULL, NULL, _t('站点LOGO地址'), _t('在这里填入一个图片URL地址, 以在网站标题前加上一个LOGO'));
    $layout->addItem($logoUrl);
}
*/

/*
 * 获取浏览次数(改进版)
 * <?php _e(getViewsCount($this)); // $this 是 Widget_Archive 对象 ?>
 */
function getViewsCount($widget) {
	$fields = unserialize($widget->fields);
	if (array_key_exists('views', $fields))
		$views = (!empty($fields['views'])) ? intval($fields['views']) : 0;
	else
		$views = 0;
	
	//增加浏览次数
	if ($widget->is('single')) {
		$vieweds = Typecho_Cookie::get('__typecho_contents_views');
		if (empty($vieweds))
			$vieweds = array();
		else
			$vieweds = explode(',', $vieweds);

		if (!in_array($widget->cid, $vieweds)) {
			$views = $views + 1;
			$widget->setField('views', 'str', strval($views), $widget->cid);
			$vieweds[] = $widget->cid;
			$vieweds = implode(',', $vieweds);
			Typecho_Cookie::set("__typecho_contents_views",$vieweds);
		}
	}

	return $views;
}
